import flet as ft


def main(page: ft.Page):
    page.title = "1.3 Получение ввода от пользователя"
    page.scroll = ft.ScrollMode.AUTO
    page.padding = 20

    # ---------- 1. КНОПКИ + СЧЁТЧИК ----------
    counter_field = ft.TextField(
        value="0",
        text_align=ft.TextAlign.RIGHT,
        width=100,
    )

    def counter_minus(e):
        counter_field.value = str(int(counter_field.value) - 1)
        page.update()

    def counter_plus(e):
        counter_field.value = str(int(counter_field.value) + 1)
        page.update()

    counter_block = ft.Column(
        [
            ft.Text("Пример 1: кнопки и счётчик", size=18, weight="bold"),
            ft.Row(
                [
                    ft.ElevatedButton("-", on_click=counter_minus),
                    counter_field,
                    ft.ElevatedButton("+", on_click=counter_plus),
                ],
                alignment=ft.MainAxisAlignment.CENTER,
            ),
        ],
        spacing=10,
    )

    # ---------- 2. TEXTFIELD (ИМЯ) + КНОПКА ----------
    name_input = ft.TextField(label="Ваше имя")
    hello_output = ft.Text()

    def say_hello(e):
        if not name_input.value.strip():
            name_input.error_text = "Как вас зовут?"
            hello_output.value = ""
        else:
            name_input.error_text = None
            hello_output.value = f"Привет, {name_input.value.strip()}!"
        page.update()

    hello_block = ft.Column(
        [
            ft.Text("Пример 2: ввод имени (TextField)", size=18, weight="bold"),
            name_input,
            ft.ElevatedButton("Поздороваться", on_click=say_hello),
            hello_output,
        ],
        spacing=10,
    )

    # ---------- 3. CHECKBOX ----------
    ski_checkbox = ft.Checkbox(
        label="ToDo: Learn how to use ski",
        value=False,
    )
    ski_output = ft.Text()

    def checkbox_changed(e):
        ski_output.value = (
            f"Вы научились кататься на лыжах: {ski_checkbox.value}."
        )
        page.update()

    # привяжем обработчик
    ski_checkbox.on_change = checkbox_changed

    checkbox_block = ft.Column(
        [
            ft.Text("Пример 3: Checkbox", size=18, weight="bold"),
            ski_checkbox,
            ski_output,
        ],
        spacing=10,
    )

    # ---------- 4. DROPDOWN ----------
    color_dropdown = ft.Dropdown(
        width=150,
        options=[
            ft.dropdown.Option("Красный"),
            ft.dropdown.Option("Зелёный"),
            ft.dropdown.Option("Синий"),
        ],
    )
    dropdown_output = ft.Text()

    def dropdown_submit(e):
        dropdown_output.value = (
            f"Значение выпадающего списка: {color_dropdown.value}"
        )
        page.update()

    dropdown_block = ft.Column(
        [
            ft.Text("Пример 4: Dropdown", size=18, weight="bold"),
            color_dropdown,
            ft.ElevatedButton("Подтвердить", on_click=dropdown_submit),
            dropdown_output,
        ],
        spacing=10,
    )

    # ---------- ДОБАВЛЯЕМ ВСЁ НА СТРАНИЦУ ----------
    page.add(
        ft.Text("1.3 Получение ввода от пользователя", size=22, weight="bold"),
        ft.Divider(),
        counter_block,
        ft.Divider(),
        hello_block,
        ft.Divider(),
        checkbox_block,
        ft.Divider(),
        dropdown_block,
    )


if __name__ == "__main__":
    ft.app(target=main)
    # Если нужно в браузере, можно так:
    # ft.app(target=main, view=ft.WEB_BROWSER)
